<?php

use App\Models\DriverUser;
use App\Models\User;
use Illuminate\Support\Facades\Broadcast;

/*
|--------------------------------------------------------------------------
| Broadcast Channels
|--------------------------------------------------------------------------
|
| Here you may register all of the event broadcasting channels that your
| application supports. The given channel authorization callbacks are
| used to check if an authenticated user can listen to the channel.
|
*/

//********** Driver **********
Broadcast::channel('newRequest.{driverId}', function ($driver, $driverId) {
    return $driver instanceof DriverUser && $driver->id == $driverId;
}, ['guards' => ['driver']]);

Broadcast::channel('removeRequest.{driverId}', function ($driver, $driverId) {
    return $driver instanceof DriverUser && $driver->id == $driverId;
}, ['guards' => ['driver']]);

Broadcast::channel('cancelRequestForDriver.{driverId}', function ($driver, $driverId) {
    return $driver instanceof DriverUser && $driver->id == $driverId;
}, ['guards' => ['driver']]);

Broadcast::channel('changeRequestForDriver.{driverId}', function ($driver, $driverId) {
    return $driver instanceof DriverUser && $driver->id == $driverId;
}, ['guards' => ['driver']]);


//********** User **********
Broadcast::channel('cancelRequestForUser.{userId}', function ($user, $userId) {
    return $user instanceof User && $user->id == $userId;
}, ['guards' => ['user']]);

Broadcast::channel('changeRequestForUser.{userId}', function ($user, $userId) {
    return $user instanceof User && $user->id == $userId;
}, ['guards' => ['user']]);

Broadcast::channel('acceptedRequest.{userId}', function ($user, $userId) {
    return $user instanceof User && $user->id == $userId;
}, ['guards' => ['user']]);
