<?php

use App\Events\NewRequestDriver;
use App\Http\Controllers\Auth\OtpUserController;
use App\Http\Controllers\Common\SupportController;
use App\Http\Controllers\User\AddressesController;
use App\Http\Controllers\User\MiscController;
use App\Http\Controllers\User\TravelController;
use App\Http\Controllers\User\UserController;
use App\Http\Controllers\User\WalletController;
use App\Services\MyService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Route;


/*
|--------------------------------------------------------------------------
| User Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "User" middleware group. Make something great!
|
*/

//Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
//    return $request->user();
//});


//Route::get('/socket', function (Request $request) {
//    try {
//        broadcast(new \App\Events\RemoveRequest([
//            'driver_id' => 1,
//            'travel_id' => 123
//        ]));
//
//        return response()->json(['status' => 'success']);
//    } catch (\Exception $e) {
//        Log::error('Broadcast test failed: '.$e->getMessage());
//        return response()->json(['error' => $e->getMessage()], 500);
//    }
//});


require base_path('routes/Common.php');

Route::post('send-code', [OtpUserController::class, 'sendCode']);
Route::post('verify-code', [OtpUserController::class, 'verifyCode']);

Route::apiResource('user', UserController::class)->only('store');


Route::middleware(['auth:user', 'check.user.blocked'])->group(function () {
    Route::apiResource('addresses', AddressesController::class)->only('index', 'store', 'destroy', 'show');
    Route::apiResource('wallet', WalletController::class)->only('index', 'store');
    Route::apiResource('travel', TravelController::class)->only('index', 'store');
    Route::apiResource('user', UserController::class)->only('update', 'show');
    Route::post('comment_about_driver', [MiscController::class, 'commentAboutDriver']);
    Route::post('travel_canceled', [MiscController::class, 'travelCanceled']);
    Route::get('travel_running', [MiscController::class, 'travelRunning']);
});


//Route::post('/run-migrations', function () {
//    Artisan::call('migrate', [
//        '--path' => 'database/migrations/2025_04_08_151833_create_travels_table.php',
//        '--force' => true,
//    ]);
//
//    Artisan::call('migrate', [
//        '--path' => 'database/migrations/2025_04_09_090056_create_travel_destinations_table.php',
//        '--force' => true,
//    ]);
//});

//Route::post('/seed', function () {
//    Artisan::call('db:seed', [
//        '--class' => 'StateCitySeeder',
//        '--force' => true,
//    ]);
//
//    return 'Seeder executed: ShahroodCitySeeder';
//});
