<?php

use App\Http\Controllers\Auth\OtpPanelController;
use App\Http\Controllers\Common\DriverCategoriesController;
use App\Http\Controllers\Common\LoadTypeController;
use App\Http\Controllers\Panel\ConfigController;
use App\Http\Controllers\Panel\SupportController;
use App\Http\Controllers\Driver\DriverController;
use App\Http\Controllers\Panel\DiscountCodeController;
use App\Http\Controllers\User\UserController;
use App\Http\Controllers\Panel\MiscController;
use App\Http\Controllers\Panel\PanelUsersController;
use App\Http\Controllers\Panel\TravelController;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Panel Routes
|--------------------------------------------------------------------------
|
| Here is where you can register panel routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "panel" middleware group. Make something great!
|
*/

require base_path('routes/Common.php');


Route::post('login_user' , [OtpPanelController::class ,'sendCode']);
Route::post('verify_user' , [OtpPanelController::class ,'verifyCode']);


Route::middleware(['auth:panel'])->group(function () {
//    Example 👇🏻
//    Route::get('users_panel', [PanelUsersController::class, 'index'])->middleware('check.ability:management,admin');
//    Route::get('users_panel/{user_panel}', [PanelUsersController::class, 'show'])->middleware('check.ability:management');
//    Route::post('users_panel', [PanelUsersController::class, 'store'])->middleware('check.ability:admin');


    Route::apiResource('users_panel', PanelUsersController::class);
    Route::apiResource('user', UserController::class);
    Route::apiResource('driver', DriverController::class);
    Route::apiResource('support', SupportController::class)->only(['index', 'destroy']);
    Route::apiResource('config', ConfigController::class)->only(['index', 'update']);
    Route::apiResource('discount_code', DiscountCodeController::class);
    Route::apiResource('travel', TravelController::class)->only(['index', 'show']);
    Route::apiResource('driver_categories', DriverCategoriesController::class)->only(['update']);
    Route::apiResource('load_types', LoadTypeController::class)->only(['update', 'index', 'store', 'destroy']);



    Route::post('update_legal_pages', [MiscController::class, 'updateLegalPages']);
    Route::get('dashboard', [MiscController::class, 'dashboard']);
});


//Route::get('/clear-cache', function () {
//    Artisan::call('cache:clear');
//    return 'Cache cleared!';
//});
