<?php

use App\Http\Controllers\Auth\OtpDriverController;
use App\Http\Controllers\Driver\BankCardsController;
use App\Http\Controllers\Driver\DriverController;
use App\Http\Controllers\Driver\MiscController;
use App\Http\Controllers\Driver\TravelController;
use App\Http\Controllers\Driver\WalletController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

require base_path('routes/Common.php');

Route::post('send-code', [OtpDriverController::class, 'sendCode']);
Route::post('verify-code', [OtpDriverController::class, 'verifyCode']);

Route::apiResource('driver', DriverController::class)->only('store');


Route::middleware(['auth:driver', 'check.driver.blocked'])->group(function () {

    Route::apiResource('driver', DriverController::class)->only('update', 'show');
    Route::apiResource('travel', TravelController::class)->only('show', 'update', 'index');
    Route::apiResource('wallet', WalletController::class)->only('index');
    Route::apiResource('bank_cards', BankCardsController::class)->only('index', 'store', 'destroy');

    Route::get('travel_running', [MiscController::class, 'travelRunning']);
    Route::get('daily_reports', [MiscController::class, 'dailyReports']);
    Route::get('travel_reports', [MiscController::class, 'travelReports']);
    Route::post('travel_canceled', [MiscController::class, 'travelCanceled']);
    Route::post('wallet_withdrawal', [MiscController::class, 'driverWalletWithdrawal']);
    Route::post('set_location', [MiscController::class, 'setLocation']);

});
