<?php

use App\Http\Controllers\Common\CommonController;
use App\Http\Controllers\Common\DriverCategoriesController;
use App\Http\Controllers\Common\LoadTypeController;
use App\Http\Controllers\Common\SupportController;
use App\Http\Controllers\Payment\PaymentController;
use App\Http\Controllers\User\ChatsController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

//Route::post('uploads', [CommonController::class, 'uploads'])->middleware('auth:panel');
Route::post('uploads', [CommonController::class, 'uploads']);

Route::get('states', [CommonController::class, 'states']);
Route::get('version', [CommonController::class, 'version']);
Route::get('legal_pages', [CommonController::class, 'legalPages']);
Route::get('support_phone', [CommonController::class, 'supportPhone']);

Route::post('new_payment', [PaymentController::class, 'newPayment']);
Route::get('back_payment', [PaymentController::class, 'backPayment']);

Route::apiResource('load_types', LoadTypeController::class)->only('index');
Route::apiResource('driver_categories', DriverCategoriesController::class)->only('index');

Route::apiResource('support', SupportController::class)->only('index', 'store')->middleware('auth.any');
Route::apiResource('chats', ChatsController::class)->only('store' , 'show')->middleware('auth.any');

