<?php

namespace Database\Seeders;

use App\Models\States;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;


class StateCitySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        DB::beginTransaction();

        // مرحله اول: استان سمنان
        $provinceData = json_decode(file_get_contents(base_path('Geojson/Provinces/31_Provinces_in_Iran.json')), true);

        $semnanProvince = collect($provinceData['features'])->first(function ($item) {
            return $item['properties']['id'] == 241475; // شناسه استان سمنان
        });

        // تبدیل به WKT
        $provinceCoordinates = $semnanProvince['geometry']['coordinates'];
        $provinceWKT = $this->convertToMultiPolygonWKT($provinceCoordinates);

        $state = States::create([
            'name' => $semnanProvince['properties']['tags']['name'],
            'parent_id' => null,
            'area' => DB::raw("ST_GeomFromText('$provinceWKT')"),
            'radius' => 10,
        ]);

        // مرحله دوم: شهر شاهرود
        $shahrudCityData = json_decode(file_get_contents(base_path('Geojson/Cities/IR-241475_geo.json')), true);

        // پیدا کردن ویژگی مربوط به شهر شاهرود
        $shahrudFeature = collect($shahrudCityData['features'])->first(function ($item) {
            return isset($item['properties']['tags']['name']) &&
                trim($item['properties']['tags']['name']) === 'شهرستان اصفهان';
        });

        if (!$shahrudFeature) {
            DB::rollBack();
            throw new \Exception('شهرستان شاهرود در فایل GeoJSON یافت نشد.');
        }

        // تبدیل مختصات به WKT
        $cityCoordinates = $shahrudFeature['geometry']['coordinates'];
        $cityWKT = $this->convertToMultiPolygonWKT($cityCoordinates);

        // درج در دیتابیس
        $state->cities()->create([
            'name' => $shahrudFeature['properties']['tags']['name'],
            'parent_id' => $state->id,
            'area' => DB::raw("ST_GeomFromText('$cityWKT')"),
            'radius' => 10,
        ]);
        DB::commit();
    }

    /**
     * تبدیل آرایه GeoJSON به MultiPolygon WKT
     */
    function convertToMultiPolygonWKT(array $coordinates): string
    {
        $polygons = [];

        foreach ($coordinates as $polygon) {
            $rings = [];

            foreach ($polygon as $ring) {
                $points = array_map(fn($point) => "{$point[0]} {$point[1]}", $ring);
                $rings[] = '(' . implode(', ', $points) . ')';
            }

            $polygons[] = '(' . implode(', ', $rings) . ')';
        }

        return 'MULTIPOLYGON(' . implode(', ', $polygons) . ')';
    }
}
