<?php

namespace Database\Seeders;

use App\Models\DriverCategories;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DriverCategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $categories = [
            [
                'name' => 'سواری',
                'type' => 'taxi',
                'vehicle' => 'car',
                'pic' => 'icon_car_taxi_default.png'
            ],
            [
                'name' => 'پیک موتوری',
                'type' => 'courier',
                'vehicle' => 'motorcycle',
                'pic' => 'icon_motorcycle_default.png'
            ],
            [
                'name' => 'وانت بار',
                'type' => 'courier',
                'vehicle' => 'car',
                'pic' => 'icon_car_courier.png'
            ],
//            [
//                'name' => 'موتورسیکلت',
//                'type' => 'taxi',
//                'vehicle' => 'motorcycle',
//                'pic' => 'icon_motorcycle_default.png'
//            ]
        ];

        foreach ($categories as $category) {
            DriverCategories::create($category);
        }

    }
}
