<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('driver_wallet_withdrawals', function (Blueprint $table) {
            $table->id();
            $table->foreignId('driver_id')->constrained('driver_users')->onDelete('cascade');
            $table->foreignId('bank_card_id')->constrained('driver_bank_cards');
            $table->unsignedBigInteger('amount'); // مبلغ مورد نظر برای تسویه
            $table->enum('status', ['pending', 'accepted', 'rejected'])->default('pending');
            $table->text('admin_note')->nullable(); // توضیحات اپراتور در صورت نیاز
            $table->timestamp('processed_at')->nullable(); // زمان انجام تسویه
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('driver_wallet_withdrawals');
    }
};
