<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('driver_users', function (Blueprint $table) {
            $table->string('address')->after('city_id');
            $table->string('postal_code')->after('address');
            $table->string('landline_phone')->after('postal_code');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('driver_users', function (Blueprint $table) {
            $table->dropColumn(['landline_phone', 'postal_code', 'address']);
        });
    }
};
