<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('driver_bank_cards', function (Blueprint $table) {
            $table->id();
            $table->foreignId('driver_id')->constrained('driver_users')->onDelete('cascade');
            $table->string('bank_name');
            $table->string('card_number');
            $table->string('shaba_number');
            $table->string('card_name');
            $table->boolean('is_deleted')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('driver_bank_cards');
    }
};
