<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('driver_wallet_history', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('driver_id');
            $table->string('action');
            $table->unsignedBigInteger('amount');
            $table->unsignedBigInteger('travel_id')->nullable()->default(null);
            $table->string('description');
            $table->unsignedBigInteger('wallet_inventory'); // موجودی کیف پول قبل از اضاف / برداشت
            $table->boolean('is_recharge_wallet')->default(false); // افزایش کیف پول
            $table->boolean('is_wallet_settlement')->default(false); // تسویه کیف پول
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('driver_wallet_history');
    }
};
