<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_wallet_history', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('uid');
            $table->string('action');
            $table->unsignedBigInteger('amount');
            $table->string('description');
            $table->unsignedBigInteger('wallet_inventory'); // موجودی کیف پول قبل از اضاف / برداشت
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_wallet_history');
    }
};
