<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('discount_codes', function (Blueprint $table) {
            $table->id();
            $table->string('code'); // کد تخفیف
            $table->unsignedBigInteger('discount_price')->nullable()->default(null); // مبلغ تخفیف
            $table->unsignedInteger('discount_percentage')->nullable()->default(null); // درصد تخفیف
            $table->string('user_type')->default('users'); //  تخفیف برای کاربران یا رانندگان
            $table->unsignedBigInteger('minimum_usage_price')->nullable()->default(null); // حداقل قیمت برای اعمال کد
            $table->unsignedBigInteger('count')->default(1); // تعداد مجاز استفاده از کد
            $table->date('expired_at')->default(now()->addDays(30)); // تاریخ انقضا کد
            $table->boolean('is_expired')->default(false); // کد منقضی شده یا نه
            $table->boolean('is_public')->default(false); // کد عمومی
            $table->boolean('is_selected_users')->default(false); // کد برای کاربران خاص
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('discount_codes');
    }
};
