<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('travel_destinations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('travel_id')->constrained('travels')->onDelete('cascade'); // شناسه سفر
            $table->unsignedInteger('order')->default(1); // برای مشخص کردن ترتیب مقصدها
            $table->decimal('lat', 10, 7); // موقعیت مقصد
            $table->decimal('lng', 10, 7); // موقعیت مقصد
            $table->string('destination_address');
            $table->decimal('distance_km');
            $table->enum('status', ['pending', 'running', 'arrived', 'completed'])->default('pending');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('travel_destinations');
    }
};
