<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('travels', function (Blueprint $table) {
            $table->id();
            $table->string('travel_code')->unique();
            $table->bigInteger('uid'); // شناسه کاربر
            $table->bigInteger('driver_id')->nullable()->default(null); // شناسه راننده
            $table->bigInteger('driver_category'); // نوع راننده
            $table->decimal('origin_lat', 10, 7); // موقعیت شروع سفر
            $table->decimal('origin_lng', 10, 7); // موقعیت شروع سفر
            $table->string('origin_address');
            $table->unsignedBigInteger('travel_price'); // مبلغ سفر بدون کارمزد و کمسیون
            $table->unsignedBigInteger('app_commission'); // مبلغ کارمزد و کمسیون
            $table->string('discount_code')->nullable()->default(null); // کد تخفیف

            $table->unsignedBigInteger('delay_time')->default(0); // گذینه های سفر - زمان توقف
            $table->boolean('commuting')->default(false); // گذینه های سفر - رفت و برگشت
            $table->enum('current_stage', ['pending', 'before_origin', 'at_origin', 'to_destination', 'at_destination', 'to_next_destination', 'to_origin', 'completed'])->default('pending');

            $table->boolean('is_running')->default(false); // سفر هایی که در حال اجرا هستند
            $table->boolean('is_canceled')->default(false); // سفر هایی که لغو شده اند
            $table->boolean('is_completed')->default(false); // سفر هایی که با موفقیت به اتمام رسیده اند
            $table->boolean('is_unsuccessful')->default(false); // سفر هایی که توسط هیچ راننده ای قبول نشده

            $table->string('cancel_type')->nullable()->default(null); // لغو سفر از جانب چه شخصی
            $table->string('cancel_description')->nullable()->default(null); // دلیل کنسل کردن سفر

            $table->string('payment_method')->nullable()->default(null); // طریقه پرداخت سفر
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('travels');
    }
};
