<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('driver_users', function (Blueprint $table) {
            $table->id();
            $table->string('first_name'); // نام
            $table->string('last_name'); // نام خانوادگی
            $table->string('mobile')->unique();
            $table->string('national_code')->unique(); // کد ملی
            $table->string('birth_certificate_number'); // شماره شناسنامه
            $table->string('father_name'); // نام پدر
            $table->date('birth_date'); // تاریخ تولد
            $table->unsignedBigInteger('state_id'); // شناسه استان
            $table->unsignedBigInteger('city_id'); // شناسه شهر
            $table->unsignedBigInteger('category_id'); // شناسه دسته بندی راننده
            $table->string('profile'); // تصویر پروفایل
            $table->string('vehicle_name'); // نام وسیله نقلیه
            $table->string('vehicle_color'); // رنگ وسیله نقلیه
            $table->string('vehicle_plate'); // پلاک خودرو
            $table->string('vin_number'); // شماره VIN
            $table->boolean('is_vehicle_owner')->default(false); // آیا ماشین متعلق به خود راننده است؟
            $table->string('vehicle_card_front_image'); // تصویر روی کارت خودرو
            $table->string('vehicle_card_back_image'); // تصویر پشت کارت خودرو
            $table->string('driving_license_front_image'); // تصویر روی گواهینامه
            $table->string('driving_license_back_image'); // تصویر پشت گواهینامه
            $table->string('insurance_code'); // کد یکتای شماره بیمه
            $table->string('insurance_national_code'); // کد ملی بیمه گزار
            $table->date('insurance_expiry_date'); // تاریخ انقضا بیمه
            $table->string('face_verification_image'); // تصویر احراز هویت چهره
            $table->string('signature_verification_image'); // تصویر احراز هویت امضا
            $table->bigInteger('wallet')->default(0); // کیف پول راننده
            $table->boolean('is_online')->default(true); // راننده سفر قبول میکند یا خیر
            $table->boolean('is_available')->default(true); // راننده در دسترس هست یا خیر
            $table->boolean('is_confirmation')->default(false); // راننده تایید شده است یا خیر
            $table->boolean('is_blocked')->default(false); // راننده بلاک است یا خیر
            $table->decimal('current_lat', 10, 7)->nullable()->default(null); // موقعیت فعلی راننده
            $table->decimal('current_lng', 10, 7)->nullable()->default(null);; // موقعیت فعلی راننده

            $table->string('fcm_token')->unique()->nullable()->default(null);
            $table->timestamps();

//            // تعریف foreign key برای ارتباط با جداول استان و شهر
//            $table->foreign('state_id')->references('id')->on('states')->onDelete('cascade');
//            $table->foreign('city_id')->references('id')->on('states')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('driver_users');
    }
};
