<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('username');
            $table->string('mobile')->unique();
            $table->unsignedBigInteger('state_id');
            $table->unsignedBigInteger('city_id');
            $table->unsignedBigInteger('wallet')->default(0);
            $table->boolean('is_blocked')->default(false);
            $table->string('fcm_token')->unique()->nullable()->default(null);
            $table->rememberToken();
            $table->timestamps();

//            // اگر نیاز داشتی می‌تونی foreign key هم تعریف کنی:
//             $table->foreign('state_id')->references('id')->on('states');
//             $table->foreign('city_id')->references('id')->on('states');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
