<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('states', function (Blueprint $table) {
            $table->id(); // id
            $table->string('name'); // نام استان یا شهر
            $table->unsignedBigInteger('parent_id')->nullable(); // برای تشخیص شهر یا استان بودن
            $table->multiPolygon('area')->nullable();
            $table->integer('radius')->default(5);  // شعاع مجاز برای شهر
            $table->boolean('is_deleted')->default(false); // حذف منطقی
            $table->timestamps();

            // اگر لازم شد رابطه با خودش:
            $table->foreign('parent_id')->references('id')->on('states')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('states');
    }
};
