<?php

namespace App\Services;

use App\Enums\TravelDestinationStatus;
use App\Enums\TravelStage;
use App\Events\AcceptedRequest;
use App\Events\CancelRequestFortDriver;
use App\Events\ChangeRequestForUser;
use App\Events\NewRequestDriver;
use App\Events\RemoveRequest;
use App\Exceptions\ValidationReturn;
use App\Models\AppConfig;
use App\Models\CommentsAboutDriver;
use App\Models\DiscountCodes;
use App\Models\DriverUser;
use App\Models\DriverWalletHistory;
use App\Models\Travels;
use App\Models\User;
use App\Models\UserWalletHistory;
use Carbon\Carbon;
use Illuminate\Contracts\Debug\ExceptionHandler;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class MyService
{
    /**
     * @throws \JsonException
     */
    public static function Decryption($decryptedData)
    {
        $cipher = 'AES-128-CBC';
        $iv = 'I8zyA4lVhMCaJ5Kg';
        $secretKey = '1122811228112281';

        $decrypted = openssl_decrypt($decryptedData, $cipher, $secretKey, 0, $iv);

        if ($decrypted === false) {
            return 'Error decrypting data'; // برای اشکال‌زدایی
        }

        return json_decode($decrypted, false, 512, JSON_THROW_ON_ERROR);
    }

    /**
     * @throws \JsonException
     */
    public static function Encryption($encryptedData)
    {
        $encryptedData = json_encode($encryptedData, JSON_THROW_ON_ERROR);

        $cipher = 'AES-128-CBC';
        $iv = 'I8zyA4lVhMCaJ5Kg';
        $secretKey = '1122811228112281';
        return openssl_encrypt($encryptedData, $cipher, $secretKey, 0, $iv);
    }

    public static function G2J($created_at): string
    {

        $timestamp = strtotime($created_at);

        // Set timezone to Tehran
        $tehranTimeZone = new \DateTimeZone('Asia/Tehran');

        // Convert timestamp to DateTime object in Tehran timezone
        $date = new \DateTime("@$timestamp");
        $date->setTimezone($tehranTimeZone);

        $g_y = $date->format('Y');
        $g_m = $date->format('m');
        $g_d = $date->format('d');

        // Get time in format H:i:s (Tehran time)
//        $time = $date->format('H:i:s');
        $time = $date->format('H:i');

        // Jalali date calculation
        $d_4 = $g_y % 4;
        $g_a = array(0, 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334);
        $doy_g = $g_a[(int)$g_m] + $g_d;
        if ($d_4 == 0 and $g_m > 2)
            $doy_g++;
        $d_33 = (int)((($g_y - 16) % 132) * 0.0305);
        $a = ($d_33 == 3 or $d_33 < ($d_4 - 1) or $d_4 == 0) ? 286 : 287;
        $b = (($d_33 == 1 or $d_33 == 2) and ($d_33 == $d_4 or $d_4 == 1)) ? 78 : (($d_33 == 3 and $d_4 == 0) ? 80 : 79);
        if ((int)(($g_y - 10) / 63) == 30) {
            $a--;
            $b++;
        }
        if ($doy_g > $b) {
            $jy = $g_y - 621;
            $doy_j = $doy_g - $b;
        } else {
            $jy = $g_y - 622;
            $doy_j = $doy_g + $a;
        }
        if ($doy_j < 187) {
            $jm = (int)(($doy_j - 1) / 31);
            $jd = $doy_j - (31 * $jm++);
        } else {
            $jm = (int)(($doy_j - 187) / 30);
            $jd = $doy_j - 186 - ($jm * 30);
            $jm += 7;
        }

        // Return Jalali date along with time (in Tehran timezone)
        return sprintf('%04d/%02d/%02d %s', $jy, $jm, $jd, $time);
    }

    public static function MessageOtp($phone, $code)
    {

        return;

        $data = array(
            "code" => "nnxoif33f6p4srz",
            "sender" => "+983000505",
            "recipient" => "$phone",
            "variable" => array(
                "verification-code" => "$code"
            )
        );

        $post_data = json_encode($data);
        $ch = curl_init('https://api2.ippanel.com/api/v1/sms/pattern/normal/send');
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'apikey: Ps3YSbeMoIo2ifoGBfZTj-eEKYkAr6fa6dW0nrrGtcY='
        ));

        $response = curl_exec($ch);
//    if (curl_errno($ch)) {
//        return 'خطا در ارسال درخواست cURL: ' . curl_error($ch);
//    } else {
//        return curl_exec($ch); // نمایش نتیجه درخواست در صورتی که مشکلی وجود نداشته باشد
//    }
        curl_close($ch);

    }


    public static function calculateTripDistanceViaGoogle(float $originLat, float $originLng, array $destinations, bool $commuting)
    {
        $apiKey = config('services.google_maps.key');

        $origin = "{$originLat},{$originLng}";
        $finalDestination = $commuting ? $origin : "{$destinations[array_key_last($destinations)]['lat']},{$destinations[array_key_last($destinations)]['lng']}";

        $waypoints = collect($destinations)
            ->map(fn($d) => "{$d['lat']},{$d['lng']}")
            ->implode('|');

        $response = Http::get('https://maps.googleapis.com/maps/api/directions/json', [
            'origin' => $origin,
            'destination' => $finalDestination,
            'waypoints' => $waypoints,
            'key' => $apiKey,
        ]);

        if (!$response->successful()) {
            return null;
        }

        return $response->json(); // کل اطلاعات برگشتی از گوگل

        $legs = $response->json('routes.0.legs');

        return collect($legs)->sum(fn($leg) => $leg['distance']['value']);
    }

//    public static function calculateTripDistanceViaORS(array $coordinates, bool $commuting = false): array
//    {
//        $apiKey = config('services.ors.key');
//        $endpoint = 'https://api.openrouteservice.org/v2/directions/driving-car/geojson';
//
//        $response = Http::withHeaders([
//            'Authorization' => $apiKey,
//            'Content-Type' => 'application/json',
//        ])->post($endpoint, [
//            'coordinates' => $coordinates
//        ]);
//
//        // بررسی خطای احتمالی
//        if ($response->failed()) {
//            $error = $response->json('error.message');
//            if (str_contains($error, 'Could not find routable point')) {
//                throw new \Exception('موقعیت مکانی انتخاب ‌شده معتبر نیست. لطفاً نقطه‌ای روی خیابان یا مسیر قابل دسترس انتخاب کنید.');
//            } else {
//                throw new \Exception('مشکلی در پردازش مسیر رخ داد.');
//            }
//        }
//
//        $segments = $response['features'][0]['properties']['segments'];
//
//        $distances = [];
//        $durations = [];
//
//        foreach ($segments as $segment) {
//            $distances[] = round($segment['distance'] / 1000);
//            $durations[] = round($segment['duration'] / 60);
//        }
//
//        $legs = [];
//        $destCount = $commuting ? count($segments) - 1 : count($segments);
//
//        foreach ($distances as $index => $distance) {
//            // تعیین مبدا و مقصد هر مسیر
//            if ($index === 0) {
//                $fromTo = $destCount > 1 ? 'از مبدا به مقصد 1' : 'از مبدا به مقصد';
//            } elseif ($commuting && $index === count($distances) - 1) {
//                $fromTo = $destCount > 1 ? 'از مقصد ' . $destCount . ' به مبدا' : 'از مقصد به مبدا';
//            } else {
//                $fromTo = 'از مقصد ' . $index . ' به مقصد ' . ($index + 1);
//            }
//
//            $legs[] = [
//                'from_to' => $fromTo,
//                'distance_km' => $distance,
//                'duration_min' => $durations[$index],
//            ];
//        }
//
//        return [
//            'routes' => $legs,
//            'total' => [
//                'distance_km' => round(array_sum($distances), 1),
//                'duration_min' => round(array_sum($durations)),
//            ],
//        ];
//    }

    public static function calculateTripDistanceViaORS(array $coordinates, bool $commuting = false, int $avgSpeedKmh = 25): array
    {
        $legs = [];
        $totalDistance = 0;
        $totalDuration = 0;

        try {
            $apiKey = config('services.ors.key');
            $endpoint = 'https://api.openrouteservice.org/v2/directions/driving-car/geojson';

            $response = Http::withHeaders([
                'Authorization' => $apiKey,
                'Content-Type' => 'application/json',
            ])->post($endpoint, [
                'coordinates' => $coordinates
            ]);

            if ($response->failed()) {
                throw new \Exception('ORS request failed');
            }

            $segments = $response['features'][0]['properties']['segments'];

            foreach ($segments as $index => $segment) {
                $distance = round($segment['distance'] / 1000);
                $duration = round($segment['duration'] / 60);

                if ($index === 0) {
                    $fromTo = count($segments) > 1 ? 'از مبدا به مقصد 1' : 'از مبدا به مقصد';
                } elseif ($commuting && $index === count($segments) - 1) {
                    $fromTo = count($segments) > 1 ? 'از مقصد ' . (count($segments) - 1) . ' به مبدا' : 'از مقصد به مبدا';
                } else {
                    $fromTo = 'از مقصد ' . $index . ' به مقصد ' . ($index + 1);
                }

                $legs[] = [
                    'from_to' => $fromTo,
                    'distance_km' => $distance,
                    'duration_min' => $duration,
                ];

                $totalDistance += $distance;
                $totalDuration += $duration;
            }
        } catch (\Exception $e) {
            // fallback با استفاده از تخمین فاصله
            for ($i = 0; $i < count($coordinates) - 1; $i++) {
                [$lng1, $lat1] = $coordinates[$i];
                [$lng2, $lat2] = $coordinates[$i + 1];

                $earthRadius = 6371;
                $dLat = deg2rad($lat2 - $lat1);
                $dLon = deg2rad($lng2 - $lng1);
                $lat1 = deg2rad($lat1);
                $lat2 = deg2rad($lat2);

                $a = sin($dLat / 2) ** 2 + sin($dLon / 2) ** 2 * cos($lat1) * cos($lat2);
                $c = 2 * atan2(sqrt($a), sqrt(1 - $a));
                $distanceKm = $earthRadius * $c * 1.6;
                $durationMin = round(($distanceKm / $avgSpeedKmh) * 60);

                $fromTo = $i === 0
                    ? (count($coordinates) > 2 ? 'از مبدا به مقصد 1' : 'از مبدا به مقصد')
                    : 'از مقصد ' . $i . ' به مقصد ' . ($i + 1);

                $legs[] = [
                    'from_to' => $fromTo,
                    'distance_km' => round($distanceKm),
                    'duration_min' => max(1, $durationMin),
                ];

                $totalDistance += $distanceKm;
                $totalDuration += $durationMin;
            }
        }

        return [
            'routes' => $legs,
            'total' => [
                'distance_km' => round($totalDistance, 1),
                'duration_min' => round($totalDuration),
            ],
        ];
    }

    public static function calculateTripDistanceViaNeshan(array $coordinates, bool $commuting = false)
    {
        $apiKey = config('services.neshan.key');
        $endpoint = 'https://api.neshan.org/v1/distance-matrix';
        $type = 'car'; // یا 'motorcycle' در صورت نیاز

        // تبدیل مختصات به فرمت مورد نیاز API نشان
        $points = array_map(function ($coord) {
            return $coord[1] . ',' . $coord[0]; // lat,lng
        }, $coordinates);

        $origins = $points[0];
        $destinations = implode('|', array_slice($points, 1));


        // ارسال درخواست به API نشان
        $response = Http::withHeaders([
            'Api-Key' => $apiKey,
        ])->get($endpoint, [
            'type' => $type,
            'origins' => $origins,
            'destinations' => $destinations,
        ]);


        // بررسی خطای احتمالی
        if ($response->failed()) {
            throw new \Exception('مشکلی در پردازش مسیر رخ داد.');
        }

        $data = $response->json();

        // بررسی وجود داده‌های مورد انتظار
        if (!isset($data['rows'][0]['elements'])) {
            throw new \Exception('پاسخ نامعتبر از سرویس نشان دریافت شد.');
        }

        $elements = $data['rows'][0]['elements'];

        $legs = [];
        $distances = [];
        $durations = [];

        foreach ($elements as $index => $element) {
            if ($element['status'] !== 'OK') {
                throw new \Exception('خطا در محاسبه مسیر برای مقصد شماره ' . ($index + 1));
            }

            $distance = round($element['distance']['value'] / 1000); // کیلومتر
            $duration = round($element['duration']['value'] / 60);   // دقیقه

            $distances[] = $distance;
            $durations[] = $duration;

            $fromTo = $index === 0
                ? 'از مبدا به مقصد 1'
                : 'از مقصد ' . $index . ' به مقصد ' . ($index + 1);

            $legs[] = [
                'from_to' => $fromTo,
                'distance_km' => $distance,
                'duration_min' => $duration,
            ];
        }

        // در صورت رفت و برگشت، افزودن مسیر بازگشت
        if ($commuting) {
            $lastDestination = end($points);
            $returnResponse = Http::withHeaders([
                'Api-Key' => $apiKey,
            ])->get($endpoint, [
                'type' => $type,
                'origins' => $lastDestination,
                'destinations' => $origins,
            ]);

            if ($returnResponse->failed()) {
                throw new \Exception('مشکلی در پردازش مسیر بازگشت رخ داد.');
            }

            $returnData = $returnResponse->json();

            if (!isset($returnData['rows'][0]['elements'][0]) || $returnData['rows'][0]['elements'][0]['status'] !== 'OK') {
                throw new \Exception('خطا در محاسبه مسیر بازگشت.');
            }

            $returnElement = $returnData['rows'][0]['elements'][0];

            $returnDistance = round($returnElement['distance']['value'] / 1000);
            $returnDuration = round($returnElement['duration']['value'] / 60);

            $distances[] = $returnDistance;
            $durations[] = $returnDuration;

            $legs[] = [
                'from_to' => 'از مقصد ' . count($elements) . ' به مبدا',
                'distance_km' => $returnDistance,
                'duration_min' => $returnDuration,
            ];
        }

        return [
            'routes' => $legs,
            'total' => [
                'distance_km' => round(array_sum($distances), 1),
                'duration_min' => round(array_sum($durations)),
            ],
        ];
    }


    public static function calculateTripTotalPrice(object $driverCategory, int $totalKm): int
    {
        $res = ($driverCategory->kilometer_price * $totalKm) + $driverCategory->base_price;

        return round($res);
    }

    public static function calculateDiscountCode(string $code = null, int $totalPrice = 0, bool $registration = false, string $guard = 'user'): int
    {

        $res = 0;

        if (!$code || !$totalPrice) {
            return $res;
        }

        $discount = DiscountCodes::where('code', $code)->first();

        if (!$discount) {
            throw new \Exception('کد تخفیف وارد شده نامعتبر است !');
        }

        if ($discount->is_expired) {
            throw new \Exception('کد تخفیف وارد شده نامعتبر است !');
        }

        if ($discount->minimum_usage_price > $totalPrice) {
            $numberPrice = number_format($discount->minimum_usage_price);
            throw new \Exception("حداقل مبلغ برای اعمال این کد تخفیف $numberPrice تومان می باشد !");
        }

        if ($discount->discount_price) {
            $res = $totalPrice - $discount->discount_price;
        }

        if ($discount->discount_percentage) {
            $res = round($totalPrice * $discount->discount_percentage / 100);
        }

        if ($discount->is_selected_users) {
            $uid = auth($guard)->id();

            if (!$uid) {
                throw new \Exception('احراز هویت شما تایید نشد !');
            }

            $select_user = $discount?->selectUsers?->where('uid', $uid)->first();

            if (!$select_user) {
                throw new \Exception('کد تخفیف وارد شده متعلق به شخص دیگری می باشد !');
            }
        }


        if ($registration) {
            $discount->count--;
            if ($discount->count < 1) $discount->is_expired = true;
            $discount->save();
        }

        return $res ?? 0;

    }

    public static function calculateDelayTime(int $delay = 0): int
    {
        if (!$delay) {
            return 0;
        }

        $price = Cache::rememberForever('price_per_minute_delay', function () {
            return AppConfig::where('title', 'price_per_minute_delay')->value('content') ?? 1000;
        });

        $priceDelay = (int)str_replace(',', '', $price);

        return round($delay * $priceDelay);
    }

    public static function generateUniqueTravelCode(int $length = 10): string
    {
        do {
            $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
            $charactersLength = strlen($characters);
            $randomString = '';

            for ($i = 0; $i < $length; $i++) {
                $randomString .= $characters[random_int(0, $charactersLength - 1)];
            }

            $code = $randomString;
        } while (Travels::where('travel_code', $code)->exists());

        return $code;
    }

    public static function estimatedDrivingTime(float|null $lat1, float|null $lng1, float|null $lat2, float|null $lng2, int $avgSpeedKmh = 25): array
    {

        if (!$lat1 || !$lat2 || !$lng1 || !$lng2) {
            return [
                'estimated_km' => 0,
                'estimated_time' => 0
            ];
        }

        // قدم اول: محاسبه فاصله مستقیم
        $earthRadius = 6371; // کیلومتر
        $dLat = deg2rad($lat2 - $lat1);
        $dLon = deg2rad($lng2 - $lng1);
        $lat1 = deg2rad($lat1);
        $lat2 = deg2rad($lat2);

        $a = sin($dLat / 2) ** 2 + sin($dLon / 2) ** 2 * cos($lat1) * cos($lat2);
        $c = 2 * atan2(sqrt($a), sqrt(1 - $a));
        $distanceKm = $earthRadius * $c;

        // قدم دوم: تخمین فاصله زمینی با ضریب پیچ‌وخم مسیر (مثلاً 1.8)
        $adjustedDistance = $distanceKm * 1.6;

        // قدم سوم: محاسبه زمان (دقیقه)
        $durationMin = round(($adjustedDistance / $avgSpeedKmh) * 60);

        if ($durationMin < 0) {
            $durationMin = 1;
        }

        if ($adjustedDistance < 0) {
            $adjustedDistance = 0;
        }

        return [
            'estimated_km' => round($adjustedDistance),
            'estimated_time' => $durationMin
        ];
    }

    public static function weekDays($createdAt): string
    {
        $daysOfWeek = [
            'Saturday' => 'شنبه',
            'Sunday' => 'یکشنبه',
            'Monday' => 'دوشنبه',
            'Tuesday' => 'سه‌شنبه',
            'Wednesday' => 'چهارشنبه',
            'Thursday' => 'پنجشنبه',
            'Friday' => 'جمعه',
        ];

        $date = Carbon::parse($createdAt);

        $dayOfWeek = $date->format('l');

        return $daysOfWeek[$dayOfWeek] ?? 'نامعتبر';
    }

    public static function averageDriverStars(int $did): float
    {

        $avgStars = CommentsAboutDriver::where('did', $did)->avg('stars');

        return $avgStars ? round($avgStars) : 0;

    }

    /**
     * @throws ValidationReturn
     */
    public static function checkRealPerson(int $user_id, string $guard): void
    {

        if (!auth('panel')->check()) {

            $uid = auth($guard)->id();

            if ($user_id != $uid) {
                throw new ValidationReturn('شناسه وارد شده متعلق به شخص دیگری می‌باشد !');
            }
        }
    }

    /**
     * @throws ValidationReturn
     */

    public static function checkDebtorDriver($driver): void
    {
        if (is_null($driver)) {
            throw new ValidationReturn('راننده در دسترس نمی باشد !');
        }

        if ($driver->wallet < 0) {
            throw new ValidationReturn('شما به اپلیکیشن بدهکار هستید و قادر به دریافت سفارش جدید نیستید');
        }
    }

    public static function travelStatus(object $travel): array
    {
        if ($travel->is_canceled) {
            return [
                'action_button' => null,
                'message_button' => "لغو شده",
                'cancel_button' => false,
                'route_message' => "سفر توسط " . ($travel->cancel_type === 'driver' ? 'راننده' : 'کاربر') . ' لغو شده است'
            ];
        }

        $hasCommuting = $travel->commuting;
        $destinations = $travel->destinations;
        $currentDestination = $destinations->where('status', TravelDestinationStatus::Running)->first();
        $arrivedDestination = $destinations->where('status', TravelDestinationStatus::Arrived)->first();
        $totalDestinations = $destinations->count();

        switch ($travel->current_stage) {
            case TravelStage::Pending:
                return [
                    'action_button' => 'accepted',
                    'message_button' => "قبول سفارش",
                    'cancel_button' => false,
                    'route_message' => "در جستوجوی راننده"
                ];

            case TravelStage::BeforeOrigin:
                return [
                    'action_button' => 'arrive_origin',
                    'message_button' => "رسیدن به مبدا",
                    'cancel_button' => true,
                    'route_message' => "راننده در مسیر مبدا است"
                ];

            case TravelStage::AtOrigin:
                return [
                    'action_button' => 'start_travel',
                    'message_button' => "شروع حرکت به سمت مقصد",
                    'cancel_button' => false,
                    'route_message' => "راننده در مبدا است"
                ];

            case TravelStage::ToDestination:
                return [
                    'action_button' => 'arrive_destination',
                    'message_button' => $totalDestinations > 2 && $hasCommuting ? "رسیدن به مقصد 1" : "رسیدن به مقصد",
                    'cancel_button' => false,
                    'route_message' => $totalDestinations > 2 && $hasCommuting ? "راننده در مسیر مقصد 1است" : "راننده در مسیر مقصد است"
                ];

            case TravelStage::AtDestination:
                if ($arrivedDestination && $arrivedDestination->order === ($totalDestinations - 1) && $hasCommuting) {
                    return [
                        'action_button' => 'start_return',
                        'message_button' => "بازگشت به مبدا",
                        'cancel_button' => false,
                        'route_message' => $totalDestinations > 2 ? "راننده در مقصد " . $arrivedDestination->order . " است" : "راننده در مقصد است"
                    ];
                }

                if ($arrivedDestination && $arrivedDestination->order === $totalDestinations) {
                    return [
                        'action_button' => 'complete_travel',
                        'message_button' => "پایان سفر",
                        'cancel_button' => false,
                        'route_message' => $totalDestinations > 2 && $hasCommuting ? "راننده در مقصد " . $arrivedDestination->order . " است" : "راننده در مقصد است"
                    ];
                }

                return [
                    'action_button' => 'next_destination',
                    'message_button' => "شروع حرکت به مقصد بعدی",
                    'cancel_button' => false,
                    'route_message' => "راننده در مقصد است"
                ];

            case TravelStage::ToNextDestination:

                $route_message = "راننده در مسیر مقصد بعدی است";

                if ($currentDestination) {
                    $prevOrder = $currentDestination->order - 1;
                    $route_message = "راننده از مقصد " . $prevOrder . " به مقصد " . $currentDestination->order . " در حرکت است";
                }

                return [
                    'action_button' => 'arrive_destination',
                    'message_button' => $totalDestinations > 2 && $hasCommuting ? "رسیدن به مقصد " . $currentDestination->order : "رسیدن به مقصد",
                    'cancel_button' => false,
                    'route_message' => $route_message
                ];

            case TravelStage::ToOrigin:
                return [
                    'action_button' => 'complete_travel',
                    'message_button' => "پایان سفر",
                    'cancel_button' => false,
                    'route_message' => 'راننده در حال بازگشت به مبدا است'
                ];

            case TravelStage::Completed:
                return [
                    'action_button' => null,
                    'message_button' => null,
                    'cancel_button' => false,
                    'route_message' => $hasCommuting ? "سفر برگشت به مبدا با موفقیت انجام شد" : "سفر به پایان رسیده است"
                ];

            default:
                return [
                    'action_button' => null,
                    'message_button' => null,
                    'cancel_button' => false,
                    'route_message' => "وضعیت سفر نامشخص است"
                ];
        }
    }

    public static function travelCurrentRoute(object $travel): string
    {
        $hasCommuting = $travel->commuting;
        $destinations = $travel->destinations;
        $currentDestination = $destinations->where('status', TravelDestinationStatus::Running)->first();
        $arrivedDestination = $destinations->where('status', TravelDestinationStatus::Arrived)->first();
        $totalDestinations = $destinations->count();

        switch ($travel->current_stage) {
            case TravelStage::Pending:
                return "در جستوجوی راننده";

            case TravelStage::BeforeOrigin:
                return "راننده در مسیر مبدا است";

            case TravelStage::AtOrigin:
                return "راننده در مبدا است";

            case TravelStage::ToDestination:
                return $totalDestinations > 2 && $hasCommuting ? "راننده در مسیر مقصد 1است" : "راننده در مسیر مقصد است";

            case TravelStage::AtDestination:
                if ($arrivedDestination) {
                    return $totalDestinations > 2 && $hasCommuting ? "راننده در مقصد " . $arrivedDestination->order . " است" : "راننده در مقصد است";
                }
                return "راننده در مقصد است";

            case TravelStage::ToNextDestination:
                if ($currentDestination) {
                    $prevOrder = $currentDestination->order - 1;
                    return "راننده از مقصد " . $prevOrder . " به مقصد " . $currentDestination->order . " در حرکت است";
                }
                return "راننده در مسیر مقصد بعدی است";

            case TravelStage::ToOrigin:
                return "راننده در حال بازگشت به مبدا است";

            case TravelStage::Completed:
                return $travel->commuting ? "سفر برگشت به مبدا با موفقیت انجام شد" : "سفر به پایان رسیده است";

            default:
                return "وضعیت سفر نامشخص است";
        }
    }

    public static function newUserWalletRecord(int $uid, int $newWallet, string $description): bool
    {

        try {
            $oldWallet = User::findOrFail($uid)?->wallet;

            if ((int)$oldWallet !== (int)$newWallet) {
                $diff = $newWallet - $oldWallet;
                $action = $diff < 0 ? 'output' : 'input';
                $amount = abs($newWallet - $oldWallet);

                $created = UserWalletHistory::create([
                    'uid' => $uid,
                    'action' => $action,
                    'amount' => $amount,
                    'description' => $description,
                    'wallet_inventory' => $oldWallet,
                ]);

                return (bool)$created;
            }

            return true;

        } catch (\Exception $exception) {
            return false;
        }

    }

    public static function newDriverWalletRecord(int $driver_id, int $newWallet, string $description): bool
    {

        try {
            $oldWallet = DriverUser::findOrFail($driver_id)?->wallet;

            if ((int)$oldWallet !== (int)$newWallet) {
                $diff = $newWallet - $oldWallet;
                $action = $diff < 0 ? 'output' : 'input';
                $amount = abs($newWallet - $oldWallet);

                $created = DriverWalletHistory::create([
                    'driver_id' => $driver_id,
                    'action' => $action,
                    'amount' => $amount,
                    'description' => $description,
                    'wallet_inventory' => $oldWallet,
                ]);

                return (bool)$created;
            }

            return true;

        } catch (\Exception $exception) {
            return false;
        }

    }

    public static function travelStringStatus(object $travel): string
    {
        if (!isset($travel)) {
            return 'نامشخص';
        }

        if ($travel->is_canceled) {
            return 'لغو شده';
        }

        if ($travel->is_unsuccessful) {
            return 'راننده ای پیدا نشد';
        }

        if ($travel->is_completed) {
            return 'پایان یافته';
        }

        if ($travel->is_running) {
            return $travel->current_stage?->persian();
        }

        return 'در جستوجوی راننده';

    }

    public static function getDriversNearby(int $driverCategory, float $originLat, float $originLng): object
    {

        $radius = Cache::rememberForever('passenger_receiving_radius', function () {
            return AppConfig::where('title', 'passenger_receiving_radius')->value('content');
        });

        $raw = "(6371 * acos(cos(radians($originLat)) * cos(radians(current_lat)) * cos(radians(current_lng) - radians($originLng)) + sin(radians($originLat)) * sin(radians(current_lat))))";

        return DriverUser::query()
            ->where('is_online', true)
            ->where('is_available', true)
            ->where('wallet', '>=', 0)
            ->where('category_id', $driverCategory)
            ->whereRaw("$raw < ?", [$radius + 2]) // کمی بزرگتر از radius چون این مسافت مستقیمه
            ->get()
            ->map(function ($driver) use ($originLat, $originLng, $radius) {
                $currentDriver = self::estimatedDrivingTime(
                    $driver->current_lat,
                    $driver->current_lng,
                    $originLat,
                    $originLng,
                );

                if ($currentDriver && isset($currentDriver['estimated_km']) && $currentDriver['estimated_km'] < $radius) {
                    $driver->currentDriver = $currentDriver;
                    return $driver;
                }

                return false;

            });

    }


//    ********** Socket **********
    public static function socketChangeRequestForUser(object $travel): void
    {

        Log::info('❗ socketChangeRequestForUser');

//        $runningDestination = $travel->destinations->where('is_running', 1)->first() ?? $travel->destinations[0];
//
//        $estimatedTime = self::estimatedDrivingTime(
//            $travel->driver?->current_lat,
//            $travel->driver?->current_lng,
//            $runningDestination?->lat,
//            $runningDestination?->lng,
//        );
//
//        $res = (object)[
//            'driver_id' => $travel->driver_id,
//            'user_id' => $travel->uid,
//            'route' => self::travelCurrentRoute($travel),
//            'estimated_time' => $estimatedTime['estimated_time']
//        ];

//        broadcast(new ChangeRequestForUser($res));

    }

    public static function socketChangeRequestForDriver(object $travel): void
    {
        $res = (object)[
            'payment' => (object)[
                'method' => $travel->payment_method,
            ]
        ];

        broadcast(new ChangeRequestForUser($res));
    }

    public static function socketCancelRequestFortDriver(object $travel, string $message): void
    {
        Log::info('❗ socketCancelRequestFortDriver');

//        broadcast(new CancelRequestFortDriver([
//            'driver_id' => $travel->driver_id,
//            'travel_id' => $travel->id,
//            'message' => $message,
//        ]));
    }

    public static function socketCancelRequestFortUser(object $travel, string $message): void
    {
        Log::info('❗ socketCancelRequestFortUser');

//        broadcast(new CancelRequestFortDriver([
//            'user_id' => $travel->uid,
//            'travel_id' => $travel->id,
//            'message' => $message,
//        ]));
    }

    public static function socketRemoveRequest(object $travel, int $driver_id): void
    {
        Log::info('❗ socketRemoveRequest');

//        broadcast(new RemoveRequest([
//            'driver_id' => $driver_id,
//            'travel_id' => $travel->id,
//        ]));
    }

    public static function socketAcceptedRequest(object $travel, int $driver_id): void
    {

        Log::info('❗ socketAcceptedRequest');


//        broadcast(new AcceptedRequest([
//            'success' => true,
//            'user_id' => $travel->uid,
//            'driver_id' => $driver_id,
//            'travel_id' => $travel->id,
//        ]));
    }


    public static function zarinpalPayment(object $payment, string $message = 'درگاه پرداخت o_pelak'):object
    {
        try {

            $data = [
                'merchant_id' => '1ac73777-76ce-45bd-8408-1fa1436f729e',
                'amount' => $payment->amount,
                'description' => $message,
                'currency' => 'IRT',
                'callback_url' => "https://back.opelak.ir/back_payment?payment_id=" . $payment->id,
            ];

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://api.zarinpal.com/pg/v4/payment/request.json');
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $res = curl_exec($ch);
            curl_close($ch);
            $res = json_decode($res, true);

            if ($res['data']['code'] == 100) {
                return response()->json([
                    'success' => true,
                    'url' => "https://www.zarinpal.com/pg/StartPay/" . $res['data']["authority"]
                ]);
            }

            return response()->json([
                'success' => false,
                'message' => 'ماسفانه مشکلی پیش آمده است !',
                'errors' => $res['errors']
            ],500);

        }catch (\Exception $e) {
            app()[ExceptionHandler::class]->report($e);
            return response()->json([
                'success' => false,
                'error' => $e->getMessage(),
                'message' => 'مشکلی پیش آمده است لطفا مجددا تلاش فرمایید !'
            ], 500);
        }

    }
}
