<?php

namespace App\Rules;

use App\Models\User;
use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class ValidUser implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
       $user = auth('user')->user();

        if (!$user) {
            $fail('احراز هویت شما تایید نشد !');
            return;
        }

        if ($user->is_blocked){
            $fail('درحال حاضر پروفایل کاربری شما مسدود شده است !');
        }
    }
}
