<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;
use Illuminate\Support\Facades\DB;

class ValidServiceArea implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */

    protected float $lat;
    protected float $lng;

    public function __construct(float $lat, float $lng)
    {
        $this->lat = $lat;
        $this->lng = $lng;
    }

    public function validate(string $attribute, mixed $value, Closure $fail): void
    {

        if (!$this->lat || !$this->lng) {
            $fail('موقعیت خود را انتخاب کنید !');
            return;
        }

        $lat = $this->lat;
        $lng = $this->lng;

        $exists = DB::table('states')
            ->where('is_deleted', false)
            ->where('parent_id', null)
            ->whereRaw("ST_Contains(area, ST_GeomFromText('POINT($lat $lng)', 4326))")
            ->exists();

        if (!$exists) {
            $fail('مبدا انتخاب شده متاسفانه در محدوده سرویس ‌دهی نیست !');
        }
    }
}
