<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;
use Illuminate\Support\Facades\DB;

class ValidOriginServiceArea implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */

    protected float $lat;
    protected float $lng;

    public ?object $city = null;

    public function __construct(float $lat, float $lng)
    {
        $this->lat = $lat;
        $this->lng = $lng;
    }

    public function validate(string $attribute, mixed $value, Closure $fail): void
    {

        if (!$this->lat || !$this->lng) {
            $fail('موقعیت خود را انتخاب کنید !');
            return;
        }

        $lat = $this->lat;
        $lng = $this->lng;

        $city  = DB::table('states')
            ->whereNotNull('parent_id')
            ->where('is_deleted', false)
            ->whereRaw("ST_Contains(area, ST_GeomFromText('POINT($lng $lat)', 4326))")
            ->first();

        if (!$city ) {
            $fail('مبدا انتخاب شده متاسفانه در محدوده سرویس ‌دهی نیست !');
            return;
        }

        $this->city = $city; // ذخیره شهر

    }

    public function getCity(): ?object
    {
        return $this->city;
    }
}
