<?php

namespace App\Rules;

use App\Models\DiscountCodes;
use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class ValidDiscountCode implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {

        $discount = DiscountCodes::where('code', $value)->first();


        if (!$discount) {
            $fail('کد تخفیف وارد شده نامعتبر است !');
            return;
        }

        if (!$discount->is_active) {
            $fail('کد تخفیف وارد شده در دسترس نمی باشد !');
            return;
        }

        if ($discount->is_expired) {
            $fail('کد تخفیف وارد شده اعتبار ندارد !');
            return;
        }

        if ($discount->expired_at <= now()) {
            $discount->is_expired = true;
            $discount->save();
            $fail('کد تخفیف وارد شده تاریخ گذشته است !');
            return;
        }

        if ($discount->count < 1) {
            $discount->is_expired = true;
            $discount->save();
            $fail('کد تخفیف وارد شده قبلا استفاده شده است !');
        }

    }
}
