<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;
use Illuminate\Support\Facades\DB;

class ValidDestinationServiceArea implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */

    protected float $lat;
    protected float $lng;

    protected ?object $originCity;
    protected bool $allowInterProvinceTravel;

    public ?object $destinationCity = null;

    public function __construct(
        float $lat,
        float $lng,
        ?object $originCity = null,
        bool $allowInterProvinceTravel = false
    ) {
        $this->lat = $lat;
        $this->lng = $lng;
        $this->originCity = $originCity;
        $this->allowInterProvinceTravel = $allowInterProvinceTravel;
    }

    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        if (!$this->lat || !$this->lng) {
            $fail('مقصد خود را انتخاب کنید.');
            return;
        }

        if (!$this->originCity) {
            $fail('مبدا انتخاب شده در محدوده سرویس دهی نمی باشد !');
            return;
        }

        $destinationCity = DB::table('states')
            ->whereNotNull('parent_id')
            ->where('is_deleted', false)
            ->whereRaw("ST_Contains(area, ST_GeomFromText('POINT($this->lng $this->lat)', 4326))")
            ->first();

        if (!$destinationCity) {
            $fail('مقصد انتخاب ‌شده در محدوده سرویس ‌دهی نیست !');
            return;
        }

        $this->destinationCity = $destinationCity;

        if ($this->originCity->parent_id !== $destinationCity->parent_id && !$this->allowInterProvinceTravel) {
            $fail('در حال حاضر سفر بین‌استانی مجاز نیست !');
        }

    }

    public function getCity(): ?object
    {
        return $this->destinationCity;
    }
}


