<?php

namespace App\Providers;

use Illuminate\Cache\RateLimiting\Limit;
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\RateLimiter;
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
    /**
     * The path to your application's "home" route.
     *
     * Typically, users are redirected here after authentication.
     *
     * @var string
     */
    public const HOME = '/home';

    /**
     * Define your route model bindings, pattern filters, and other route configuration.
     */
    public function boot(): void
    {
//        RateLimiter::for('User', function (Request $request) {
//            return Limit::perMinute(1000)->by($request->user()?->id ?: $request->ip());
//        });
//
//        RateLimiter::for('Driver', function (Request $request) {
//            return Limit::perMinute(1000)->by($request->user()?->id ?: $request->ip());
//        });
//
//        RateLimiter::for('Common', function (Request $request) {
//            return Limit::perMinute(1000)->by($request->user()?->id ?: $request->ip());
//        });
//
//        RateLimiter::for('Panel', function (Request $request) {
//            return Limit::perMinute(1000)->by($request->user()?->id ?: $request->ip());
//        });

        $this->routes(function () {
            Route::middleware('api')
                ->prefix('api')
                ->group(base_path('routes/api.php'));

            Route::middleware('Driver')
                ->prefix('Driver')
                ->group(base_path('routes/Driver.php'));

            Route::middleware('User')
                ->prefix('User')
                ->group(base_path('routes/User.php'));

            Route::middleware('web')
                ->group(base_path('routes/web.php'));

            Route::middleware('common')
                ->group(base_path('routes/Common.php'));

            Route::middleware('Panel')
                ->prefix('Panel')
                ->group(base_path('routes/Panel.php'));
        });
    }
}
