<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserDiscountCodes extends Model
{
    use HasFactory;

    protected $table = 'users_discount_codes';

    protected $fillable = [
        'uid',
        'code_id',
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'uid', 'id');
    }

    public function discunt_code()
    {
        return $this->belongsTo(DiscountCodes::class, 'code_id', 'id');
    }
}
