<?php

namespace App\Models;

use App\Enums\TravelDestinationStatus;
use App\Enums\TravelStage;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;

class Travels extends Model
{
    use HasFactory;

    protected $table = 'travels';

    protected $fillable = [
        'travel_code',
        'uid',
        'driver_id',
        'driver_category',
        'origin_lat',
        'origin_lng',
        'origin_address',
        'travel_price',
        'app_commission',
        'discount_code',
        'delay_time',
        'commuting',
        'is_running',
        'is_canceled',
        'is_completed',
        'is_unsuccessful',
        'cancel_type',
        'cancel_description',
        'current_stage',
        'payment_method',
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    protected $casts = [
        'current_stage' => TravelStage::class,
    ];

    public function destinations(): HasMany
    {
        return $this->hasMany(TravelDestinations::class, 'travel_id', 'id');
    }

    public function details(): HasOne
    {
        return $this->hasOne(TravelDetails::class, 'travel_id');
    }

    public function driver(): BelongsTo
    {
        return $this->belongsTo(DriverUser::class, 'driver_id');
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uid');
    }

    public function comment():  BelongsTo
    {
        return $this->belongsTo(CommentsAboutDriver::class,'travel_id');
    }
    public function driverCategory(): BelongsTo
    {
        return $this->belongsTo(DriverCategories::class, 'driver_category');
    }


    public function getHasStartedAttribute(): bool
    {
        return $this?->destinations?->contains(function ($dest) {
            return $dest?->status !== TravelDestinationStatus::Pending;
        });
    }

    public function scopePeriodFilter($query, $start, $end)
    {
        if($start && $end) {
            return $query->whereBetween('created_at', [$start, $end]);
        }
        return $query;
    }

}
