<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class TravelDetails extends Model
{
    use HasFactory;

    protected $table = 'travel_details';

    protected $fillable = [
        'travel_id',
        'recipient_name',
        'mobile',
        'address',
        'description',
        'value_price',
        'load_type_id',
        'payment_recipient',
    ];

    protected  $hidden = [
        'created_at',
        'updated_at',
    ];

    public function loadType(): BelongsTo
    {
        return $this->belongsTo(LoadTypes::class , 'load_type_id');
    }
}
