<?php

namespace App\Models;

use App\Enums\TravelDestinationStatus;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TravelDestinations extends Model
{
    use HasFactory;

    protected $table = 'travel_destinations';

    protected $fillable = [
        'travel_id',
        'order',
        'lat',
        'lng',
        'destination_address',
        'distance_km',
        'status',
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    protected $casts = [
        'status' => TravelDestinationStatus::class,
    ];
}
