<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Support extends Model
{
    use HasFactory;

    protected $table = 'support';

    protected $fillable = [
        'uid',
        'user_type',
        'title',
        'description',
        'answer',
        'seen',
    ];

    protected $hidden = [
      'created_at',
      'updated_at',
    ];

    public function user():BelongsTo
    {
        return $this->belongsTo(User::class, 'uid', 'id');
    }

    public function driver():BelongsTo
    {
        return $this->belongsTo(DriverUser::class, 'uid', 'id');
    }

}
