<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class States extends Model
{
    use HasFactory;

    protected $table = 'states';

    protected $spatialFields = [
        'area', // فیلدی که مختصات Polygon روش ذخیره می‌شه
    ];

    protected $fillable = [
        'name',
        'parent_id',
        'is_deleted',
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
        'is_deleted',
    ];

    public function cities()
    {
        return $this->hasMany(__CLASS__, 'parent_id', 'id');
    }
}
