<?php

namespace App\Models;

use App\Enums\PaymentActions;
use App\Enums\PaymentsStatus;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use SebastianBergmann\CodeCoverage\Driver\Driver;

class Payments extends Model
{
    use HasFactory;

    protected $table = 'payments';

    protected $fillable = [
        'uid',
        'driver_id',
        'travel_id',
        'amount',
        'device',
        'answer',
        'status',
        'action',
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    protected $casts = [
        'status' => PaymentsStatus::class,
        'action' => PaymentActions::class,
    ];


    public function travel(): BelongsTo
    {
        return $this->belongsTo(Travels::class, 'travel_id');
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uid');
    }

    public function driver(): BelongsTo
    {
        return $this->belongsTo(DriverUser::class, 'driver_id');
    }
}
