<?php

namespace App\Models;

use App\Enums\WalletWithdrawalStatus;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DriverWalletWithdrawals extends Model
{
    use HasFactory;

    protected $table = 'driver_wallet_withdrawals';

    protected $fillable = [
        'driver_id',
        'bank_card_id',
        'amount',
        'status',
        'admin_note',
        'processed_at',
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    protected $casts = [
        'processed_at' => 'timestamp',
        'status'=> WalletWithdrawalStatus::class,
    ];
}
