<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class DriverWalletHistory extends Model
{
    use HasFactory;

    protected $table = 'driver_wallet_history';

    protected $fillable = [
        'driver_id',
        'action',
        'amount',
        'travel_id',
        'description',
        'wallet_inventory',
        'commission_amount',
        'is_recharge_wallet',
        'is_wallet_settlement'
    ];

    protected $hidden = [
        'created_at',
        'updated_at'
    ];

    public function travel(): BelongsTo
    {
        return $this->belongsTo(Travels::class, 'travel_id');
    }
}
