<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class DriverUser extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'driver_users';

    protected $fillable = [
        'first_name',
        'last_name',
        'mobile',
        'national_code',
        'birth_certificate_number',
        'father_name',
        'birth_date',
        'state_id',
        'city_id',
        'address',
        'postal_code',
        'landline_phone',
        'category_id',
        'profile',
        'vehicle_name',
        'vehicle_color',
        'vehicle_plate',
        'vin_number',
        'is_vehicle_owner',
        'vehicle_card_front_image',
        'vehicle_card_back_image',
        'driving_license_front_image',
        'driving_license_back_image',
        'insurance_code',
        'insurance_national_code',
        'insurance_expiry_date',
        'face_verification_image',
        'signature_verification_image',
        'wallet',
        'stars',
        'is_online',
        'is_available',
        'is_confirmation',
        'is_blocked',
        'current_lat',
        'current_lng',
        'fcm_token ',
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
    ];


    public function category() : BelongsTo
    {
        return $this->BelongsTo(DriverCategories::class, 'category_id');
    }

    public function walletHistory(): HasMany
    {
        return $this->hasMany(DriverWalletHistory::class, 'driver_id');
    }

    public function getProfileAttribute($value)
    {
        if (is_null($value)) {
            return env('PIC_URL') . env('PIC_DEFAULT');
        }

        if (!str_starts_with($value, env('PIC_URL'))) {
            return env('PIC_URL') . $value;
        }

    }

    public function getDrivingLicenseBackImageAttribute($value)
    {
        if (is_null($value)) {
            return env('PIC_URL') . env('PIC_DEFAULT');
        }

        if (!str_starts_with($value, env('PIC_URL'))) {
            return env('PIC_URL') . $value;
        }

    }
    public function getDrivingLicenseFrontImageAttribute($value)
    {
        if (is_null($value)) {
            return env('PIC_URL') . env('PIC_DEFAULT');
        }

        if (!str_starts_with($value, env('PIC_URL'))) {
            return env('PIC_URL') . $value;
        }

    }
    public function getFaceVerificationImageAttribute($value)
    {
        if (is_null($value)) {
            return env('PIC_URL') . env('PIC_DEFAULT');
        }

        if (!str_starts_with($value, env('PIC_URL'))) {
            return env('PIC_URL') . $value;
        }

    }
    public function getSignatureVerificationImageAttribute($value)
    {
        if (is_null($value)) {
            return env('PIC_URL') . env('PIC_DEFAULT');
        }

        if (!str_starts_with($value, env('PIC_URL'))) {
            return env('PIC_URL') . $value;
        }

    }
    public function getVehicleCardBackImageAttribute($value)
    {
        if (is_null($value)) {
            return env('PIC_URL') . env('PIC_DEFAULT');
        }

        if (!str_starts_with($value, env('PIC_URL'))) {
            return env('PIC_URL') . $value;
        }

    }
    public function getVehicleCardFrontImageAttribute($value)
    {
        if (is_null($value)) {
            return env('PIC_URL') . env('PIC_DEFAULT');
        }

        if (!str_starts_with($value, env('PIC_URL'))) {
            return env('PIC_URL') . $value;
        }

    }

    /**
     * @throws \JsonException
     */
    public function getVehiclePlateAttribute($value)
    {
            return json_decode($value, true, 512, JSON_THROW_ON_ERROR);
    }

    public function state(): BelongsTo
    {
        return $this->belongsTo(States::class, 'state_id');
    }

    public function city():belongsTo
    {
        return $this->belongsTo(States::class, 'city_id');
    }
}
