<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DriverCategories extends Model
{
    use HasFactory;

    protected $table = 'driver_categories';

    protected $fillable = [
        'name',
        'base_price',
        'kilometer_price',
        'pic',
        'type',
        'vehicle',
        'is_active',
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    public function getPicAttribute($value)
    {
        if (is_null($value)) {
            return env('PIC_URL') . env('PIC_DEFAULT');
        }

        if (!str_starts_with($value, env('PIC_URL'))) {
            return env('PIC_URL') . $value;
        }

    }
}
