<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class DriverBankCards extends Model
{
    use HasFactory;

    protected $table = 'driver_bank_cards';

    protected $fillable = [
        'driver_id',
        'bank_name',
        'card_number',
        'shaba_number',
        'card_name',
        'is_deleted'
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
        'is_deleted'
    ];

    public function driver(): BelongsTo
    {
        return $this->belongsTo(DriverUser::class, 'driver_id');
    }

}
