<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class DiscountCodes extends Model
{
    use HasFactory;

    protected $table = 'discount_codes';

    protected $fillable = [
        'code',
        'discount_price',
        'discount_percentage',
        'user_type',
        'minimum_usage_price',
        'count',
        'expired_at',
        'is_active',
        'is_expired',
        'is_public',
        'is_selected_users',
    ];

    protected  $hidden = [
        'created_at',
        'updated_at',
    ];

    public function selectUsers(): HasMany
    {
        return $this->hasMany(UsersDiscountCodes::class , 'code_id' , 'id');
    }
}
