<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Chats extends Model
{
    use HasFactory;

    protected $table = 'chats';

    protected $fillable = [
        'uid',
        'did',
        'travel_id',
        'user_type',
        'message',
    ];

    protected $hidden = [
        'uid',
        'did',
        'travel_id',
        'created_at',
        'updated_at',
    ];

    public function user():object
    {
        return $this->belongsTo(User::class, 'uid', 'id');
    }

    public function driver():object
    {
        return $this->belongsTo(DriverUser::class , 'did', 'id');
    }
    public function travel()
    {
        return $this->belongsTo(Travels::class, 'travel_id', 'id');
    }
}
