<?php

namespace App\Jobs;

//use Illuminate\Bus\Queueable;
//use Illuminate\Contracts\Queue\ShouldQueue;
//use Illuminate\Foundation\Bus\Dispatchable;
//use Illuminate\Queue\InteractsWithQueue;
//use Illuminate\Queue\SerializesModels;
use App\Enums\TravelStage;
use App\Models\Travels;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;

class UnsuccessfulTravels
{
//    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     */
    public function __construct()
    {
        //
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        Travels::where([
            'current_stage' => TravelStage::Pending,
            'is_unsuccessful' => 0,
            'is_canceled' => 0,
        ])
            ->where('created_at', '<=', Carbon::now()->subMinutes(2))
            ->update([
                'is_unsuccessful' => 1,
            ]);
    }
}
