<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckUserIsBlocked
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = auth('user')->user();

        if ($user && $user->is_blocked) {
            return response()->json([
                'success' => false,
                'message' => 'اکانت شما مسدود شده است. لطفاً با پشتیبانی تماس بگیرید.',
            ], 403);
        }

        return $next($request);
    }
}
