<?php

namespace App\Http\Middleware;

use App\Facades\MyServiceFacade;
use App\Models\AppConfig;
use App\Services\MyService;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckUserAppUpdate
{
    /**
     * Handle an incoming request.
     *
     * @param \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response) $next
     */
    public function handle(Request $request, Closure $next): Response
    {

        $updating = env('USER_APP_UPDATING');

        if ($updating) {
            return response()->json([
                'success' => false,
                'message' => 'برنامه در حال تغییرات می باشد لطفا تا دقایقی دیگر مجدد تلاش فرمایید !',
            ],503);
        }

        return $next($request);
    }
}

