<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckPanelUsersIsBlocked
{
    /**
     * Handle an incoming request.
     *
     * @param \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response) $next
     */
    public function handle(Request $request, Closure $next): Response
    {

        $userPanel = auth('panel')->user();

        if ($userPanel && $userPanel->is_blocked) {
            return response()->json([
                'success' => false,
                'message' => 'اکانت شما مسدود شده است. لطفاً با مدیریت تماس بگیرید.',
            ], 403);
        }

        return $next($request);
    }
}
