<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckDriverIsBlocked
{
    /**
     * Handle an incoming request.
     *
     * @param \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response) $next
     */
    public function handle(Request $request, Closure $next): Response
    {

        $driver = auth('driver')->user();

        if ($driver) {
            if ($driver->is_blocked) {
                return response()->json([
                    'success' => false,
                    'message' => 'اکانت شما مسدود شده است. لطفاً با پشتیبانی تماس بگیرید.',
                ], 403);
            }

            if ($driver->is_confirmation < 0) {
                return response()->json([
                    'success' => false,
                    'message' => 'اکانت شما رد شده است. لطفاً با پشتیبانی تماس بگیرید.',
                ], 403);
            }

            if (!$driver->is_confirmation) {
                return response()->json([
                    'success' => false,
                    'message' => 'اکانت شما تایید نشده است. لطفاً با پشتیبانی تماس بگیرید.',
                ], 403);
            }
        } else {

            return response()->json([
                'success' => false,
                'message' => 'احراز هویت شما تایید نشد !',
            ], 401);

        }

        return $next($request);
    }
}
