<?php

namespace App\Http\Middleware;

use App\Enums\UserPanelTypes;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckAbilityPanel
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next, ...$abilities): Response
    {
        $user = $request->user();

        if (!$user) {
            return response()->json([
                'success' => false,
                'message' => 'احراز هویت شما تایید نشد !',
            ], 401);
        }

        if ($user->tokenCan(UserPanelTypes::Management->value)) {
            return $next($request);
        }

//        foreach ($abilities as $ability) {
//            if ($user->tokenCan($ability)) {
//                return $next($request);
//            }
//        }

        foreach ($abilities as $ability) {
            if ($ability instanceof UserPanelTypes) {
                $ability = $ability->value;
            }

            if ($user->tokenCan($ability)) {
                return $next($request);
            }
        }

        return response()->json([
            'success' => false,
            'message' => 'شما اجازه دسترسی به این بخش را ندارید.',
        ], 403);
    }
}
