<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class AuthAnyGuard
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (auth('user')->check()) {
            return $next($request);
        }

        if (auth('driver')->check()) {
            return $next($request);
        }

        if (auth('panel')->check()) {
            return $next($request);
        }


        return response()->json([
            'success' => false,
            'message' => 'احراز هویت انجام نشد!',
        ], 401);
    }
}
