<?php

namespace App\Http\Controllers\Panel;

use App\Http\Controllers\Controller;
use App\Models\Support;
use App\Services\MyService;
use Exception;
use Illuminate\Contracts\Debug\ExceptionHandler;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class SupportController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request): object
    {
        try {

            $validator = Validator::make($request->all(), [
                'user_type' => ['required', 'string', 'in:user,driver'],
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->errors()->first()
                ], 422);
            }

            $userType = $request['user_type'];
            $dontSeenIds = [];
            $supports = Support::where('user_type', $userType)
                ->get()
                ->map(function ($support) use ($userType, &$dontSeenIds) {
                    $date = explode(' ', MyService::G2J($support->created_at));

                    $username = $userType === 'user' ? $support->user->username : $support->driver->first_name . ' ' . $support->driver->last_name;

                    if (!$support->seen) {
                        $dontSeenIds[] = $support->id;
                    }

                    return [
                        'id' => $support->id,
                        'date' => $date[0],
                        'time' => $date[1],
                        'title' => $support->title,
                        'description' => $support->description ?? 'مشخص نشده',
                        'username' => $username,
                    ];

                });

            Support::whereIn('id', $dontSeenIds)->update(['seen' => true]);

            return response()->json([
                'success' => true,
                'message' => 'عملیات با موفقیت انجام شد',
                'response' => $supports
            ]);


        } catch (Exception $e) {
            app()[ExceptionHandler::class]->report($e);
            return response()->json([
                'success' => false,
                'error' => $e->getMessage(),
                'message' => 'مشکلی پیش آمده است لطفا مجددا تلاش فرمایید !'
            ], 500);
        }
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id): object
    {
        try {

            $validator = Validator::make(['id' => $id], [
                'id' => ['required', 'integer', 'exists:support,id'],
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->errors()->first()
                ]);
            }

            Support::destroy($id);

            return response()->json([
                'success' => true,
                'message' => 'پیام پشتیبانی با موفقیت حذف شد'
            ]);

        } catch (Exception $e) {
            app()[ExceptionHandler::class]->report($e);
            return response()->json([
                'success' => false,
                'error' => $e->getMessage(),
                'message' => 'مشکلی پیش آمده است لطفا مجددا تلاش فرمایید !'
            ], 500);
        }
    }
}
