<?php

namespace App\Http\Controllers\Panel;

use App\Http\Controllers\Controller;
use App\Models\AppConfig;
use App\Models\Travels;
use Illuminate\Contracts\Debug\ExceptionHandler;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Morilog\Jalali\Jalalian;

class MiscController extends Controller
{
    public function updateLegalPages(Request $request): object
    {
        try {

            $validator = Validator::make($request->all(), [
                'type' => ['required', 'string', 'in:user,driver'],
                'action' => ['required', 'string', 'in:about_us,privacy_policy,rules'],
                'content' => ['required', 'string', 'min:10'],
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'status' => false,
                    'message' => $validator->errors()->first(),
                ], 422);
            }

            $title = $validator->getData()['type'] . '_' . $validator->getData()['action'];

            $update = AppConfig::where('title', $title)->update(['content' => $validator->getData()['content']]);

            if ($update){
                return response()->json([
                    'status' => true,
                    'message' => 'عملیات با موفقیت انجام شد',
                ]);
            }

            return response()->json([
                'status' => false,
                'message' => 'متاسفانه عملیات انجام نشد !',
            ],500);

        } catch (\Exception $e) {
            app()[ExceptionHandler::class]->report($e);
            return response()->json([
                'success' => false,
                'error' => $e->getMessage(),
                'message' => 'مشکلی پیش آمده است لطفا مجددا تلاش فرمایید !'
            ], 500);
        }
    }

    public function dashboard(): object
    {
        try {
            $allTravels = Travels::all();

            $completedTravels = $allTravels->where('is_completed', 1);
            $canceledTravels = $allTravels->where('is_canceled', 1);
            $unsuccessfulTravels = $allTravels->where('is_unsuccessful', 1);
            $runningTravels = $allTravels->where('is_running', 1);

            $total = count($allTravels);
            $res['percent_canceled'] = $total > 0 ? round((count($canceledTravels) / $total) * 100, 1) : 0;
            $res['percent_completed'] = $total > 0 ? round((count($completedTravels) / $total) * 100, 1) : 0;
            $res['percent_unsuccessful'] = $total > 0 ? round((count($unsuccessfulTravels) / $total) * 100, 1) : 0;

            $res['count_running_travels'] = count($runningTravels);
            $res['count_all_travels'] = $total;
            $res['all_profit'] = $completedTravels->sum('app_commission');

            // امروز
            $todayStart = Jalalian::now()->toCarbon()->startOfDay();
            $todayEnd = Jalalian::now()->toCarbon()->endOfDay();
            $todayProfit = $completedTravels
                ->whereBetween('created_at', [$todayStart, $todayEnd])
                ->sum('app_commission');

            // دیروز
            $yesterdayStart = Jalalian::now()->subDays(1)->toCarbon()->startOfDay();
            $yesterdayEnd = Jalalian::now()->subDays(1)->toCarbon()->endOfDay();
            $yesterdayProfit = $completedTravels
                ->whereBetween('created_at', [$yesterdayStart, $yesterdayEnd])
                ->sum('app_commission');

            $res['today_profit'] = $todayProfit;
//            $res['yesterday_profit'] = $yesterdayProfit;

            // مقایسه
            if ($todayProfit > $yesterdayProfit) {
                $res['font_color'] = '#3f8600';
                $res['today_profit_change'] = 'up';
            } elseif ($todayProfit < $yesterdayProfit) {
                $res['font_color'] = '#cf1322';
                $res['today_profit_change'] = 'down';
            } else {
                $res['font_color'] = '#ffffff';
                $res['today_profit_change'] = 'equal';
            }

            return response()->json([
                'success' => true,
                'message' => 'عملیات با موفقیت انجام شد',
                'response' => $res,
            ]);

        } catch (\Exception $e) {
            app()[ExceptionHandler::class]->report($e);
            return response()->json([
                'success' => false,
                'error' => $e->getMessage(),
                'message' => 'مشکلی پیش آمده است لطفا مجددا تلاش فرمایید !'
            ], 500);
        }
    }
}
