<?php

namespace App\Http\Controllers\Panel;

use App\Http\Controllers\Controller;
use App\Models\AppConfig;
use Exception;
use Illuminate\Contracts\Debug\ExceptionHandler;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Validator;

class ConfigController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(): object
    {
        try {

            $titles = ['support_phone', 'passenger_receiving_radius', 'price_per_minute_delay', 'app_commission'];

            $res = AppConfig::whereIn('title', $titles)
                ->pluck('content', 'title');

            return response()->json([
                'success' => true,
                'message' => 'عملیات با موفقیت انجام شد',
                'response' => $res,
            ]);

        } catch (Exception $e) {
            app()[ExceptionHandler::class]->report($e);
            return response()->json([
                'success' => false,
                'error' => $e->getMessage(),
                'message' => 'مشکلی پیش آمده است لطفا مجددا تلاش فرمایید !'
            ], 500);
        }
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request): object
    {
        try {

            $validator = Validator::make($request->all(), [
                'app_commission' => ['sometimes', 'required', 'numeric', 'min:0', 'max:100'],
                'price_per_minute_delay' => ['sometimes', 'required', 'numeric'],
                'support_phone' => ['sometimes', 'required', 'numeric', 'digits:11'],
                'passenger_receiving_radius' => ['sometimes', 'required', 'integer', 'min:1', 'max:50'],
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->errors()->first(),
                ]);
            }

            $data = $validator->validated();

            foreach ($data as $title => $content) {
                Cache::forget($title);

                AppConfig::updateOrCreate(
                    ['title' => $title],
                    ['content' => $content]
                );
            }

            return response()->json([
                'success' => true,
                'message' => 'عملیات با موفقیت انجام شد'
            ]);

        } catch (Exception $e) {
            app()[ExceptionHandler::class]->report($e);
            return response()->json([
                'success' => false,
                'error' => $e->getMessage(),
                'message' => 'مشکلی پیش آمده است لطفا مجددا تلاش فرمایید !'
            ], 500);
        }

    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
