<?php

namespace App\Http\Controllers\Driver;

use App\Http\Controllers\Controller;
use App\Services\MyService;
use Illuminate\Contracts\Debug\ExceptionHandler;
use Illuminate\Http\Request;

class WalletController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(): object
    {
        try {

            $driver = auth('driver')->user();

            $res = [
                'wallet' => $driver->wallet,
                'history' => $driver->walletHistory->map(function ($item) {

                    $date = explode(' ' , MyService::G2J($item->created_at));

                    return [
                        'date' => $date[0],
                        'time' => $date[1],
                        'amount' => $item->amount,
                        'action' => $item->action,
                        'travel_code' => $item->travel?->travel_code ?? null,
                        'total_amount' => $item->travel?->travel_price ?? null,
                        'commission' => $item->travel?->app_commission ?? null,
                        'description' => $item->description,
                    ];
                })
            ];

            return response()->json([
                'success' => true,
                'message' => 'عملیات با موفقیت انجام شد',
                'response' => $res
            ]);

        } catch (\Exception $e) {
            app()[ExceptionHandler::class]->report($e);
            return response()->json([
                'success' => false,
                'error' => $e->getMessage(),
                'message' => 'مشکلی پیش آمده است لطفا مجددا تلاش فرمایید !'
            ], 500);
        }
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
